/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import tallestegg.guardvillagers.GuardPacketHandler;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.GuardContainer;
import tallestegg.guardvillagers.entities.GuardEntity;
import tallestegg.guardvillagers.networking.GuardFollowPacket;
import tallestegg.guardvillagers.networking.GuardSetPatrolPosPacket;

public class GuardInventoryScreen
extends ContainerScreen<GuardContainer> {
    private static final ResourceLocation GUARD_GUI_TEXTURES = new ResourceLocation("guardvillagers", "textures/container/inventory.png");
    private static final ResourceLocation GUARD_FOLLOWING_ICON = new ResourceLocation("guardvillagers", "textures/container/following_icons.png");
    private static final ResourceLocation GUARD_NOT_FOLLOWING_ICON = new ResourceLocation("guardvillagers", "textures/container/not_following_icons.png");
    private static final ResourceLocation PATROL_ICON = new ResourceLocation("guardvillagers", "textures/container/patrollingui.png");
    private static final ResourceLocation NOT_PATROLLING_ICON = new ResourceLocation("guardvillagers", "textures/container/notpatrollingui.png");
    private final GuardEntity guard;
    private PlayerEntity player;
    private float mousePosX;
    private float mousePosY;
    private boolean buttonPressed;

    public GuardInventoryScreen(GuardContainer container, PlayerInventory playerInventory, GuardEntity guard) {
        super((Container)container, playerInventory, guard.func_145748_c_());
        this.guard = guard;
        this.field_238742_p_ = 80;
        this.field_238744_r_ = 100;
        this.field_230711_n_ = false;
        this.player = playerInventory.field_70458_d;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.player.func_70644_a(Effects.field_220310_F)) {
            this.func_230480_a_((Widget)new GuardGuiButton(this.field_147003_i + 100, this.field_230709_l_ / 2 - 40, 20, 18, 0, 0, 19, GUARD_FOLLOWING_ICON, GUARD_NOT_FOLLOWING_ICON, true, p_214086_1_ -> GuardPacketHandler.INSTANCE.sendToServer((Object)new GuardFollowPacket(this.guard.func_145782_y()))));
        }
        if (GuardConfig.setGuardPatrolHotv && this.player.func_70644_a(Effects.field_220310_F) || !GuardConfig.setGuardPatrolHotv) {
            this.func_230480_a_((Widget)new GuardGuiButton(this.field_147003_i + 120, this.field_230709_l_ / 2 - 40, 20, 18, 0, 0, 19, PATROL_ICON, NOT_PATROLLING_ICON, false, p_214086_1_ -> {
                this.buttonPressed = !this.buttonPressed;
                GuardPacketHandler.INSTANCE.sendToServer((Object)new GuardSetPatrolPosPacket(this.guard.func_145782_y(), this.buttonPressed));
            }));
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUARD_GUI_TEXTURES);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        InventoryScreen.func_228187_a_((int)(i + 51), (int)(j + 75), (int)30, (float)((float)(i + 51) - this.mousePosX), (float)((float)(j + 75 - 50) - this.mousePosY), (LivingEntity)this.guard);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        int health = MathHelper.func_76123_f((float)this.guard.func_110143_aJ());
        int armor = this.guard.func_70658_aO();
        TranslationTextComponent guardHealthText = new TranslationTextComponent("guardinventory.health", new Object[]{health});
        TranslationTextComponent guardArmorText = new TranslationTextComponent("guardinventory.armor", new Object[]{armor});
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)guardHealthText, 80.0f, 20.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)guardArmorText, 80.0f, 30.0f, 0x404040);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.mousePosX = mouseX;
        this.mousePosY = mouseY;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    class GuardGuiButton
    extends ImageButton {
        private ResourceLocation texture;
        private ResourceLocation newTexture;
        private boolean isFollowButton;

        public GuardGuiButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, ResourceLocation newTexture, boolean isFollowButton, Button.IPressable onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
            this.texture = resourceLocationIn;
            this.newTexture = newTexture;
            this.isFollowButton = isFollowButton;
        }

        public boolean requirementsForTexture() {
            boolean following = GuardInventoryScreen.this.guard.isFollowing();
            boolean patrol = GuardInventoryScreen.this.guard.isPatrolling();
            return this.isFollowButton ? following : patrol;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ResourceLocation icon = this.requirementsForTexture() ? this.texture : this.newTexture;
            minecraft.func_110434_K().func_110577_a(icon);
            int i = this.field_191748_q;
            if (this.func_230449_g_()) {
                i += this.field_191749_r;
            }
            RenderSystem.enableDepthTest();
            GuardGuiButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)this.field_191747_p, (float)i, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.field_212935_e, (int)this.field_212936_f);
            if (this.func_230449_g_()) {
                this.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        }
    }
}

